package com.biz.crm.cps.business.agreement.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 协议阶梯
 *
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AgreementLadder", description = "协议阶梯实体对象")
@TableName("agreement_ladder")
public class AgreementLadderVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 1844292520514899475L;
  /**
   * 阶梯编码
   */
  @ApiModelProperty("阶梯编码")
  @TableField(value = "ladder_code")
  @Column(name = "ladder_code", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 阶梯编码 '")
  private String ladderCode;

  /**
   * 阶梯名称
   */
  @Column(name = "ladder_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 阶梯名称 '")
  @ApiModelProperty("阶梯名称")
  @TableField(value = "ladder_name")
  private String ladderName;

  /**
   * 阶梯类别(包量/陈列)
   */
  @Column(name = "ladder_type", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 阶梯类别 '")
  @ApiModelProperty("阶梯类别")
  @TableField(value = "ladder_type")
  private String ladderType;

  /**
   * 一月份销量（标箱）
   */
  @ApiModelProperty("一月份销量（标箱）")
  @TableField(value = "january_sale_num")
  @Column(name = "january_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 一月份销量(标箱) '")
  private BigDecimal januarySaleNum;

  /**
   * 二月份销量（标箱）
   */
  @ApiModelProperty("二月份销量（标箱）")
  @TableField(value = "february_sale_num")
  @Column(name = "february_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 二月份销量(标箱) '")
  private BigDecimal februarySaleNum;

  /**
   * 三月份销量（标箱）
   */
  @ApiModelProperty("三月份销量（标箱）")
  @TableField(value = "march_sale_num")
  @Column(name = "march_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 三月份销量(标箱) '")
  private BigDecimal marchSaleNum;

  /**
   * 四月份销量（标箱）
   */
  @ApiModelProperty("四月份销量（标箱）")
  @TableField(value = "april_sale_num")
  @Column(name = "april_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 四月份销量(标箱) '")
  private BigDecimal aprilSaleNum;

  /**
   * 五月份销量（标箱）
   */
  @ApiModelProperty("五月份销量（标箱）")
  @TableField(value = "may_sale_num")
  @Column(name = "may_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 五月份销量(标箱) '")
  private BigDecimal maySaleNum;

  /**
   * 六月份销量（标箱）
   */
  @ApiModelProperty("六月份销量（标箱）")
  @TableField(value = "june_sale_num")
  @Column(name = "june_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 六月份销量(标箱) '")
  private BigDecimal juneSaleNum;

  /**
   * 七月份销量（标箱）
   */
  @ApiModelProperty("七月份销量（标箱）")
  @TableField(value = "july_sale_num")
  @Column(name = "july_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 七月份销量(标箱) '")
  private BigDecimal julySaleNum;

  /**
   * 八月份销量（标箱）
   */
  @ApiModelProperty("八月份销量（标箱）")
  @TableField(value = "august_sale_num")
  @Column(name = "august_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 八月份销量(标箱) '")
  private BigDecimal augustSaleNum;

  /**
   * 九月份销量（标箱）
   */
  @ApiModelProperty("九月份销量（标箱）")
  @TableField(value = "september_sale_num")
  @Column(name = "september_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 九月份销量(标箱) '")
  private BigDecimal septemberSaleNum;

  /**
   * 十月份销量（标箱）
   */
  @ApiModelProperty("十月份销量（标箱）")
  @TableField(value = "october_sale_num")
  @Column(name = "october_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 十月份销量(标箱) '")
  private BigDecimal octoberSaleNum;

  /**
   * 十一月份销量（标箱）
   */
  @ApiModelProperty("十一月份销量（标箱）")
  @TableField(value = "november_sale_num")
  @Column(name = "november_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 十一月份销量(标箱) '")
  private BigDecimal novemberSaleNum;

  /**
   * 十二月份销量（标箱）
   */
  @ApiModelProperty("十二月份销量（标箱）")
  @TableField(value = "december_sale_num")
  @Column(name = "december_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 十二月份销量(标箱) '")
  private BigDecimal decemberSaleNum;

  /**
   * 年度销量（标箱）
   */
  @ApiModelProperty("年度销量（标箱）")
  @TableField(value = "year_sale_num")
  @Column(name = "year_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 年度销量(标箱) '")
  private BigDecimal yearSaleNum;

  /**
   * 陈列面达标个数
   */
  @ApiModelProperty("陈列面达标个数")
  @TableField(value = "display_number")
  @Column(name = "display_number", nullable = false, length = 16, columnDefinition = "int(64) COMMENT ' 陈列面达标个数 '")
  private Integer displayNumber;
}
