package com.biz.crm.cps.business.agreement.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Set;

/**
 * @author jerry7
 * @date 2021/8/5 14:46
 * 分利协议VO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "agreementTemplateVo", description = "分利协议模板VO")
public class AgreementTemplateVo extends TenantFlagOpVo {
  private static final long serialVersionUID = 4007895096951684472L;

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  private String templateCode;

  /**
   * 模板名称
   */
  @ApiModelProperty("模板名称")
  private String templateName;

  /**
   * 协议生效开始日期
   */
  @ApiModelProperty("协议生效开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date effectiveStartTime;

  /**
   * 协议生效结束日期
   */
  @ApiModelProperty("协议生效结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date effectiveEndTime;

  /**
   * 协议签署开始日期
   */
  @ApiModelProperty("协议签署开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signStartTime;

  /**
   * 协议签署结束日期
   */
  @ApiModelProperty("协议签署结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signEndTime;

  /**
   * 状态回显字段，启用/禁用
   */
  @ApiModelProperty("协议模板状态,启用/禁用")
  private String enableStatus;

  /**
   * 已生成协议数量
   */
  @ApiModelProperty("已生成协议数量")
  private Integer generatedAgreementNumber;

  /**
   * 是否自动签署（Y/N） 默认为N
   */
  @ApiModelProperty("自动签署(Y/N)")
  private String autoSign;

  /**
   * 协议模板关联所属组织列表
   */
  @ApiModelProperty("所属组织列表")
  private String templateOrgNameStr;

  /**
   * 协议模板包含政策列表
   */
  @ApiModelProperty("包含政策列表")
  private String templatePolicyNameStr;

  /**
   * 协议模板包含政策列表
   */
  @ApiModelProperty("包含政策列表")
  private Set<String> templatePolicyNames;

  /**
   * 协议模板包含渠道
   */
  @ApiModelProperty("包含渠道列表,名称转换字符串")
  private String templateChannelNameStr;

  /**
   * 协议模板关联所属组织列表
   */
  @ApiModelProperty("所属组织列表")
  private Set<TemplateOrgRelationshipVo> templateOrgRelationships;

  /**
   * 协议模板包含政策列表
   */
  @ApiModelProperty("包含政策列表")
  private Set<TemplatePolicyRelationshipVo> templatePolicyRelationships;


  /**
   * 协议模板包含标签
   */
  @ApiModelProperty("包含标签列表")
  private Set<TemplateTagVo> templateTags;

  /**
   * 协议模板包含渠道
   */
  @ApiModelProperty("包含渠道列表")
  private Set<TemplateChannelRelationshipVo> templateChannelRelationships;

  /**
   * 协议文本
   */
  @ApiModelProperty("协议文本")
  private String agreementText;

  /**
   * 系统时间
   */
  @ApiModelProperty("系统时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date systemTime;

  /**
   * 权限类型
   */
  @ApiModelProperty("权限类型：0全部终端门店，1部分终端门店，2指定终端门店")
  private Integer permissionType;

  /**
   * 指定终端门店编码集合
   */
  @ApiModelProperty("指定终端门店编码集合")
  private Set<TemplateTerminalRelationshipVo> templateTerminalRelationships;
}
