package com.biz.crm.cps.business.agreement.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 分利协议vo
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AgreementVo", description = "分利协议vo")
public class AgreementVo extends TenantOpVo {
  private static final long serialVersionUID = 273308966404106493L;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  private String agreementCode;

  /**
   * 协议名称
   */
  @ApiModelProperty("协议名称")
  private String agreementName;

  /**
   * 所属协议模板编码
   */
  @ApiModelProperty("所属协议模板编码")
  private String templateCode;

  /**
   * 所属协议模板
   */
  @ApiModelProperty("所属协议模板")
  private String belongTemplate;

  /**
   * 关联终端编码
   */
  @ApiModelProperty("关联终端编码")
  private String terminalCode;

  /**
   * 关联终端
   */
  @ApiModelProperty("关联终端")
  private String relationTerminal;

  /**
   * 关联经销商编码
   */
  @ApiModelProperty("关联经销商编码")
  private String customerCode;

  /**
   * 关联经销商
   */
  @ApiModelProperty("关联经销商")
  private String relationDealer;


  /**
   * 协议状态
   */
  @ApiModelProperty("协议状态")
  private String agreementStatus;

  /**
   * 签署状态
   */
  @ApiModelProperty("签署状态")
  private String signStatus;

  /**
   * 终端签署状态
   */
  @ApiModelProperty("终端签署状态")
  private String terminalSignStatus;

  /**
   * 经销商签署状态
   */
  @ApiModelProperty("经销商签署状态")
  private String dealerSignStatus;

  /**
   * 协议生效开始日期
   */
  @ApiModelProperty("协议生效开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date effectiveStartTime;

  /**
   * 协议生效结束日期
   */
  @ApiModelProperty("协议生效结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date effectiveEndTime;

  /**
   * 协议签署开始日期
   */
  @ApiModelProperty("协议签署开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signStartTime;

  /**
   * 协议签署结束日期
   */
  @ApiModelProperty("协议签署结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signEndTime;

  /**
   * 签署时间
   */
  @ApiModelProperty("签署时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signTime;

  /**
   * 模板信息
   */
  @ApiModelProperty("模板信息")
  private ProfitAgreementTemplateVo profitAgreementTemplateVo;

  /**
   * 协议文本
   */
  @ApiModelProperty("协议文本")
  private String agreementText;

  /**
   * 签名照片文件名
   */
  @ApiModelProperty("签名照片文件名")
  private String signatureFilename;

  /**
   * 签名照片文件夹
   */
  @ApiModelProperty("签名照片文件夹")
  private String signaturePath;

  /**
   * 政策名称集合
   */
  @ApiModelProperty("政策名称集合")
  private List<String> policyNames;
}
