package com.biz.crm.cps.business.agreement.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Set;

/**
 * @author songjingen
 * 分利协议模板vo
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProfitAgreementTemplateVo", description = "分利协议模板vo")
public class ProfitAgreementTemplateVo extends TenantFlagOpVo {
  private static final long serialVersionUID = 4229775537476390668L;

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  private String templateCode;

  /**
   * 模板名称
   */
  @ApiModelProperty("模板名称")
  private String templateName;

  /**
   * 协议生效开始日期
   */
  @ApiModelProperty("协议生效开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date effectiveStartTime;

  /**
   * 协议生效结束日期
   */
  @ApiModelProperty("协议生效结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date effectiveEndTime;

  /**
   * 协议签署开始日期
   */
  @ApiModelProperty("协议签署开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signStartTime;

  /**
   * 协议签署结束日期
   */
  @ApiModelProperty("协议签署结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date signEndTime;

  /**
   * 已生成协议数量
   */
  @ApiModelProperty("已生成协议数量")
  private Integer generatedAgreementNumber;

  /**
   * 协议文本
   */
  @ApiModelProperty("协议文本")
  private String agreementText;

  /**
   * 是否自动签署（Y/N） 默认为N
   */
  @ApiModelProperty("自动签署(Y/N)")
  private String autoSign;

  /**
   * 协议模板包含政策列表
   */
  @ApiModelProperty("包含政策列表")
  private Set<TemplatePolicyRelationshipVo> templatePolicyRelationshipVos;

  /**
   * 权限类型
   */
  @ApiModelProperty("权限类型：0全部终端门店，1部分终端门店，2指定终端门店")
  private Integer permissionType;

  /**
   * 指定终端门店编码集合
   */
  @ApiModelProperty("指定终端门店编码集合")
  private Set<TemplateTerminalRelationshipVo> templateTerminalRelationships;

}
