package com.biz.crm.cps.business.agreement.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author jerry7
 * @date 2021-07-23
 * 协议模板与渠道关联实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TemplateChannelRelationship", description = "协议模板与渠道关联表")
public class TemplateChannelRelationshipVo extends BaseIdVo {
  private static final long serialVersionUID = -6177464611562548443L;

  /**
   * 分利协议模板编码
   */
  @ApiModelProperty("模板编码")
  private String templateCode;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String channelCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String channelName;
}
