package com.biz.crm.cps.business.agreement.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author jerry7
 * @date 2021-07-21
 * 协议模板与组织关联实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TemplateOrgRelationship", description = "协议模板与组织关联表")
public class TemplateOrgRelationshipVo extends BaseIdVo {
  private static final long serialVersionUID = 2398248965094366388L;

  /**
   * 分利协议模板编码
   */
  @ApiModelProperty("模板编码")
  private String templateCode;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  private String orgName;
}
