package com.biz.crm.cps.business.agreement.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @author songjingen
 * 协议模板与政策关联vo
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TemplatePolicyRelationshipVo", description = "协议模板与政策关联vo")
public class TemplatePolicyRelationshipVo extends BaseIdVo {

  private static final long serialVersionUID = 1435631472634295873L;

  /**
   * 分利协议模板编码
   */
  @Column(name = "template_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 模板编码 '")
  @ApiModelProperty("模板编码")
  private String templateCode;

  /**
   * 分利政策编码
   */
  @Column(name = "policy_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 分利政策编码 '")
  @ApiModelProperty("分利政策编码")
  private String policyCode;

  /**
   * 分利政策名称
   */
  @Column(name = "policy_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 分利政策名称 '")
  @ApiModelProperty("分利政策名称")
  private String policyName;
}
