package com.biz.crm.cps.business.agreement.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 协议模板与指定终端关联表
 * @Author: zengxingwang
 * @Date: 2021/11/19 10:11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TemplateTerminalRelationship", description = "协议模板与指定终端关联表")
public class TemplateTerminalRelationshipVo {
  /**
   * 指定终端编码
   */
  @ApiModelProperty("指定终端编码")
  private String terminalCode;

  /**
   * name = "terminal_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 分利终端名称 '"
   */
  @ApiModelProperty("分利终端名称")
  private String terminalName;

  /**
   * name = "terminal_type", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 分利终端类型 '"
   */
  @ApiModelProperty("分利终端类型")
  private String terminalType;

  /**
   * name = "organization", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织 '"
   */
  @ApiModelProperty("所属组织名称")
  private String organization;

  /**
   * name = "channel_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 渠道名称 '"
   */
  @ApiModelProperty("渠道名称")
  private String channelName;

  @ApiModelProperty("终端标签")
  private String tagDescription;
}
