package com.biz.crm.cps.business.attendance.local.controller;

import com.biz.crm.cps.business.attendance.local.entity.AttendanceClock;
import com.biz.crm.cps.business.attendance.local.service.AttendanceClockService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockConditionDto;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 考勤打卡明细(AttendanceClock)表相关的http接口
 *
 * @author dy
 * @since 2022-03-07 10:29:40
 */
@RestController
@RequestMapping("/v1/attendance/attendanceClock")
@Slf4j
@Api(tags = "考勤打卡明细:AttendanceClock:考勤打卡明细")
public class AttendanceClockController {
  /**
   * 服务对象
   */
  @Autowired
  private AttendanceClockService attendanceClockService;

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<AttendanceClock> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      AttendanceClock attendanceClock = this.attendanceClockService.findById(id);
      return Result.ok(attendanceClock);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
    try {
      this.attendanceClockService.delete(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 打卡
   *
   * @param attendanceClockDto 打卡dto
   * @return 打卡结果
   */
  @PostMapping("")
  @ApiOperation("上班打卡")
  public Result<AttendanceClock> create(@ApiParam(name = "attendanceClockDto", value = "打卡dto") @RequestBody AttendanceClockDto attendanceClockDto) {
    try {
      AttendanceClock attendanceClock = this.attendanceClockService.create(attendanceClockDto);
      return Result.ok(attendanceClock);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
