package com.biz.crm.cps.business.attendance.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockConditionDto;
import com.biz.crm.cps.business.attendance.sdk.service.AttendanceClockVoService;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceClockVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 勤打卡明细(AttendanceClockVo)表相关的http接口
 * @Author dy
 * @DATE 2022/3/15
 **/
@RestController
@RequestMapping("/v1/attendance/attendanceClock")
@Slf4j
@Api(tags = "考勤打卡明细:AttendanceClockVo:考勤打卡明细")
public class AttendanceClockVoController {

  @Autowired
  private AttendanceClockVoService attendanceClockVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable        分页对象
   * @param dto 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<AttendanceClockVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "dto", value = "考勤打卡明细查询实体") AttendanceClockConditionDto dto) {
    try {
      Page<AttendanceClockVo> page = this.attendanceClockVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
