package com.biz.crm.cps.business.attendance.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceDetailReportConditionDto;
import com.biz.crm.cps.business.attendance.sdk.service.AttendanceDetailReportVoService;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceDetailReportVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 考勤报表接口
 * @Author dy
 * @DATE 2022/3/3
 **/
@RestController
@RequestMapping("/v1/attendance/attendanceDetailReport")
@Slf4j
@Api(tags = "考勤报表:AttendanceDetailReportVo:考勤报表")
public class AttendanceDetailReportVoController {

  @Autowired
  private AttendanceDetailReportVoService attendanceDetailReportVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto 考勤报表查询对象
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<AttendanceDetailReportVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "dto", value = "考勤报表查询对象") AttendanceDetailReportConditionDto dto) {
    try {
      Page<AttendanceDetailReportVo> page =  this.attendanceDetailReportVoService.findByConditions(pageable,dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
