package com.biz.crm.cps.business.attendance.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceDetailSettlement;
import com.biz.crm.cps.business.attendance.local.service.AttendanceDetailSettlementService;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceDetailConditionDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

/**
 * 考勤详情结算(AttendanceDetailSettlement)表相关的http接口
 *
 * @author dy
 * @since 2022-03-03 17:36:13
 */
@RestController
@RequestMapping("/v1/attendance/attendanceDetailSettlement")
@Slf4j
@Api(tags = "考勤详情结算:AttendanceDetailSettlement:考勤详情结算")
public class AttendanceDetailSettlementController {
  /**
   * 服务对象
   */
  @Autowired
  private AttendanceDetailSettlementService attendanceDetailSettlementService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto 考勤详情查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<AttendanceDetailSettlement>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                   @ApiParam(name = "dto", value = "考勤详情查询实体") AttendanceDetailConditionDto dto) {
    try {
      Page<AttendanceDetailSettlement> page = this.attendanceDetailSettlementService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<AttendanceDetailSettlement> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      AttendanceDetailSettlement attendanceDetailSettlement = this.attendanceDetailSettlementService.findById(id);
      return Result.ok(attendanceDetailSettlement);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
    try {
      this.attendanceDetailSettlementService.delete(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 手动结算指定日期的考勤数据
   */
  @PostMapping("hanlderAttendanceReportByDate")
  public Result<?> hanlderAttendanceReportByDate(@ApiParam(name = "date",value = "指定日期") @RequestParam @DateTimeFormat(pattern = "yyyy-MM-dd") Date date) {
    try {
      this.attendanceDetailSettlementService.hanlderAttendanceReportByDate(date);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
