package com.biz.crm.cps.business.attendance.local.controller;

import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftApplication;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftApplicationService;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftApplicationApproveDto;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftApplicationDto;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 排班申请(ShiftApplication)表相关的http接口
 *
 * @author dy
 * @since 2022-02-16 14:55:15
 */
@RestController
@RequestMapping("/v1/attendance/shiftApplication")
@Slf4j
@Api(tags = "排班申请:AttendanceShiftApplication:排班申请")
public class AttendanceShiftApplicationController {
  /**
  * 服务对象
  */
  @Autowired
  private AttendanceShiftApplicationService attendanceShiftApplicationService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto 排班申请查询对象
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<AttendanceShiftApplication>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                   @ApiParam(name = "dto", value = "排班申请查询对象") ShiftApplicationConditionDto dto) {
    try {
      Page<AttendanceShiftApplication> page =  this.attendanceShiftApplicationService.findByConditions(pageable,dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<AttendanceShiftApplication> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      AttendanceShiftApplication attendanceShiftApplication = this.attendanceShiftApplicationService.findById(id);
      return Result.ok(attendanceShiftApplication);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param attendanceShiftApplicationDto 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<AttendanceShiftApplication> create(@ApiParam(name = "attendanceShiftApplication", value = "排班申请") @RequestBody AttendanceShiftApplicationDto attendanceShiftApplicationDto) {
    try {
      AttendanceShiftApplication result = this.attendanceShiftApplicationService.create(attendanceShiftApplicationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param attendanceShiftApplicationDto 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<AttendanceShiftApplication> update(@ApiParam(name = "attendanceShiftApplication", value = "排班申请") @RequestBody AttendanceShiftApplicationDto attendanceShiftApplicationDto) {
    try {
      AttendanceShiftApplication result = this.attendanceShiftApplicationService.update(attendanceShiftApplicationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
    try {
      this.attendanceShiftApplicationService.delete(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量审核
   * @param dto 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "批量审核")
  @PatchMapping("updateAuditStatusById")
  public Result<?> updateAuditStatusByIdBatch(@ApiParam(name = "dto", value = "批量审核") @RequestBody AttendanceShiftApplicationApproveDto dto) {
    try {
      this.attendanceShiftApplicationService.updateAuditStatusByIdBatch(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
