package com.biz.crm.cps.business.attendance.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import com.biz.crm.cps.business.attendance.sdk.service.AttendanceShiftApplicationVoService;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftApplicationVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * 排班申请Vo controller
 * @Author dy
 * @DATE 2022/2/18
 **/
@RestController
@RequestMapping("/v1/attendance/shiftApplication")
@Slf4j
@Api(tags = "排班申请:AttendanceShiftApplicationVo:排班申请")
public class AttendanceShiftApplicationVoController {

  @Autowired
  private AttendanceShiftApplicationVoService attendanceShiftApplicationVoService;

  /**
   * 分页查询所有数据(包含详情)
   *
   * @param pageable 分页对象
   * @param dto 查询条件实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findDetailsByConditions")
  public Result<Page<AttendanceShiftApplicationVo>> findDetailsByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                            @ApiParam(name = "dto", value = "上班班次管理") ShiftApplicationConditionDto dto) {
    try {
      Page<AttendanceShiftApplicationVo> page =  this.attendanceShiftApplicationVoService.findDetailsByConditions(pageable,dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据详情(包含关联数据）
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据详情(包含关联数据）")
  @GetMapping("findDetailsById")
  public Result<AttendanceShiftApplicationVo> findDetailsById(@RequestParam("id") @ApiParam(name = "id", value = "主键id") String id) {
    try {
      AttendanceShiftApplicationVo attendanceShiftApplicationVo = this.attendanceShiftApplicationVoService.findDetailsById(id);
      return Result.ok(attendanceShiftApplicationVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过编码查询单条数据详情(包含关联数据）
   *
   * @param applyCode 申请编码
   * @return 单条数据
   */
  @ApiOperation(value = "通过编码查询单条数据详情(包含关联数据）")
  @GetMapping("findDetailsByApplyCode")
  public Result<AttendanceShiftApplicationVo> findDetailsByApplyCode(@RequestParam("shiftCode") @ApiParam(name = "shiftCode", value = "申请编码") String applyCode) {
    try {
      AttendanceShiftApplicationVo attendanceShiftApplicationVo = this.attendanceShiftApplicationVoService.findDetailsByApplyCode(applyCode);
      return Result.ok(attendanceShiftApplicationVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据用户账号和申请周期查询申请详情，applyPeriodDate可选周期内的任意一天(包含关联数据）
   *
   * @param applyPeriodDate 查询的周期内的任意一天
   * @return 单条数据
   */
  @ApiOperation(value = "根据用户账号和申请周期查询申请详情，applyPeriodDate可选周期内的任意一天(包含关联数据）")
  @GetMapping("findByCurrentUserAndApplyPeriodDate")
  public Result<AttendanceShiftApplicationVo> findByCurrentUserAndApplyPeriodDate(@RequestParam("applyPeriodDate") @ApiParam(name = "applyPeriodDate",value = "申请周期内的任意一天") @DateTimeFormat(pattern = "yyyy-MM-dd") Date applyPeriodDate) {
    try {
      AttendanceShiftApplicationVo attendanceShiftApplicationVo = this.attendanceShiftApplicationVoService.findByCurrentUserAndApplyPeriodDate(applyPeriodDate);
      return Result.ok(attendanceShiftApplicationVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据当前登录导购用户查询排班计划
   *
   * @param date 查询日期
   * @return 单条数据
   */
  @ApiOperation(value = "根据导购用户账号查询排班计划")
  @GetMapping("findByCurrentUserAndDate")
  public Result<AttendanceShiftApplicationVo> findByCurrentUserAndDate(@RequestParam("date") @ApiParam(name = "date", value = "查询日期") @DateTimeFormat(pattern = "yyyy-MM-dd") Date date) {
    try {
      AttendanceShiftApplicationVo attendanceShiftApplicationVo = this.attendanceShiftApplicationVoService.findByCurrentUserAndDate(date);
      return Result.ok(attendanceShiftApplicationVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
