package com.biz.crm.cps.business.attendance.local.controller;

import com.biz.crm.cps.business.attendance.local.entity.AttendanceShift;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftService;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftDto;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 上班班次管理(Shift)表相关的http接口
 *
 * @author makejava
 * @since 2022-02-16 15:40:38
 */
@RestController
@RequestMapping("/v1/attendance/shift")
@Slf4j
@Api(tags = "上班班次管理:AttendanceShift:上班班次管理")
public class AttendanceShiftController {
  /**
  * 服务对象
  */
  @Autowired
  private AttendanceShiftService attendanceShiftService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto 查询条件实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<AttendanceShift>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                        @ApiParam(name = "dto", value = "上班班次管理") ShiftConditionDto dto) {
    try {
      Page<AttendanceShift> page =  this.attendanceShiftService.findByConditions(pageable,dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<AttendanceShift> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      AttendanceShift attendanceShift = this.attendanceShiftService.findById(id);
      return Result.ok(attendanceShift);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param attendanceShiftDto 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<AttendanceShift> create(@ApiParam(name = "attendanceShift", value = "上班班次管理") @RequestBody AttendanceShiftDto attendanceShiftDto) {
    try {
      AttendanceShift result = this.attendanceShiftService.create(attendanceShiftDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param attendanceShiftDto 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<AttendanceShift> update(@ApiParam(name = "attendanceShift", value = "上班班次管理") @RequestBody AttendanceShiftDto attendanceShiftDto) {
    try {
      AttendanceShift result = this.attendanceShiftService.update(attendanceShiftDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
    try {
      this.attendanceShiftService.delete(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据当前登录用户查询可用的班次
   *
   * @return 可用班次列表
   */
  @GetMapping("findByCurrentUser")
  @ApiOperation("根据当前登录用户查询可用的班次")
  public Result<List<AttendanceShift>> findByCurrentUser() {
    try {
      List<AttendanceShift> attendanceShiftList = this.attendanceShiftService.findByCurrentUser();
      return Result.ok(attendanceShiftList);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据用户账号查询可用的班次
   *
   * @return 可用班次列表
   */
  @GetMapping("findByUserAccount")
  @ApiOperation("根据用户账号查询可用的班次")
  public Result<List<AttendanceShift>> findByUserAccount(@RequestParam("userAccount") @ApiParam(name = "userAccount", value = "用户账号")String userAccount) {
    try {
      List<AttendanceShift> attendanceShiftList = this.attendanceShiftService.findByUserAccount(userAccount);
      return Result.ok(attendanceShiftList);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
