package com.biz.crm.cps.business.attendance.local.controller;

import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftPlan;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftPlanService;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * 排班计划控制器
 * @Author dy
 * @DATE 2022/3/4
 **/
@RestController
@RequestMapping("/v1/attendance/attendanceShiftPlan")
@Slf4j
@Api(tags = "排班计划:AttendanceShiftPlan:排班计划")
public class AttendanceShiftPlanController {

  @Autowired
  private AttendanceShiftPlanService attendanceShiftPlanService;

  /**
   * 根据当前登录导购用户查询当日排班计划
   *
   * @param date 查询日期
   * @return 单条数据
   */
  @ApiOperation(value = "根据导购用户账号查询当日排班计划")
  @GetMapping("findByCurrentUserAndDate")
  public Result<AttendanceShiftPlan> findByCurrentUserAndDate(@RequestParam("date") @ApiParam(name = "date", value = "查询日期") @DateTimeFormat(pattern = "yyyy-MM-dd") Date date) {
    try {
      AttendanceShiftPlan attendanceShiftPlan = this.attendanceShiftPlanService.findByCurrentUserAndDate(date);
      return Result.ok(attendanceShiftPlan);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
