package com.biz.crm.cps.business.attendance.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShift;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import com.biz.crm.cps.business.attendance.sdk.service.AttendanceShiftVoService;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * 上班班次管理Vo controller
 * @Author dy
 * @DATE 2022/2/18
 **/
@RestController
@RequestMapping("/v1/attendance/shift")
@Slf4j
@Api(tags = "上班班次管理:AttendanceShiftVo:上班班次管理")
public class AttendanceShiftVoController {

  @Autowired
  private AttendanceShiftVoService attendanceShiftVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto 查询条件实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findDetailsByConditions")
  public Result<Page<AttendanceShiftVo>> findDetailsByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "dto", value = "上班班次管理") ShiftConditionDto dto) {
    try {
      Page<AttendanceShiftVo> page =  this.attendanceShiftVoService.findDetailsByConditions(pageable,dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据详情(包含关联数据）
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据详情(包含关联数据）")
  @GetMapping("findDetailsById")
  public Result<AttendanceShiftVo> findDetailsById(@RequestParam("id") @ApiParam(name = "id", value = "主键id") String id) {
    try {
      AttendanceShiftVo attendanceShiftVo = this.attendanceShiftVoService.findDetailsById(id);
      return Result.ok(attendanceShiftVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过编码查询单条数据详情(包含关联数据）
   *
   * @param shiftCode 班次编码
   * @return 单条数据
   */
  @ApiOperation(value = "通过编码查询单条数据详情(包含关联数据）")
  @GetMapping("findDetailsByShiftCode")
  public Result<AttendanceShiftVo> findDetailsByShiftCode(@RequestParam("shiftCode") @ApiParam(name = "shiftCode", value = "班次编码") String shiftCode) {
    try {
      AttendanceShiftVo attendanceShiftVo = this.attendanceShiftVoService.findDetailsByShiftCode(shiftCode);
      return Result.ok(attendanceShiftVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
