package com.biz.crm.cps.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 考勤打卡明细
 * @Author dy
 * @DATE 2022/2/11
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceClock", description = "考勤打卡明细")
@TableName("attendance_clock")
@Entity
@javax.persistence.Table(name = "`attendance_clock`",indexes = {@Index(columnList = "attendance_date,clock_type"),
                                                                @Index(columnList = "shift_plan_id")})
@org.hibernate.annotations.Table(appliesTo = "`attendance_clock`", comment = "考勤打卡明细")
public class AttendanceClock extends TenantFlagOpEntity {

  @ApiModelProperty("考勤日期")
  @TableField("attendance_date")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd")
  @Column(name = "attendance_date", nullable = false, columnDefinition = "date COMMENT '考勤日期'")
  private Date attendanceDate;

  @ApiModelProperty("打卡时间")
  @TableField("clock_date")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "clock_date", nullable = true, columnDefinition = "datetime COMMENT '打卡时间'")
  private Date clockDate;

  @ApiModelProperty("打卡类型")
  @TableField("clock_type")
  @Column(name = "clock_type",nullable = false,length = 64,columnDefinition = "VARCHAR(64) COMMENT ' 打卡类型 '")
  private String clockType;

  @ApiModelProperty("打卡状态")
  @TableField("clock_status")
  @Column(name = "clock_status",nullable = false,length = 64,columnDefinition = "VARCHAR(64) COMMENT ' 打卡状态 '")
  private String clockStatus;

  @ApiModelProperty("打卡经度")
  @TableField("longitude")
  @Column(name = "longitude",nullable = true,length = 64,columnDefinition = "decimal(12,8) COMMENT ' 打卡经度 '")
  private BigDecimal longitude;

  @ApiModelProperty("打卡纬度")
  @TableField("latitude")
  @Column(name = "latitude",nullable = true,length = 64,columnDefinition = "decimal(12,8) COMMENT ' 打卡纬度 '")
  private BigDecimal latitude;

  @ApiModelProperty("打卡地址编码")
  @TableField(value = "clock_address_code")
  @Column(name = "clock_address_code", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '打卡地址编码'")
  private String clockAddressCode;

  @ApiModelProperty("打卡详细地址地址")
  @TableField("clock_address")
  @Column(name = "clock_address",nullable = true,length = 255,columnDefinition = "VARCHAR(255) COMMENT ' 打卡详细地址地址 '")
  private String clockAddress;

  @ApiModelProperty("打卡人员姓名")
  @TableField("user_name")
  @Column(name = "user_name",nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 打卡人员姓名 '")
  private String userName;

  @ApiModelProperty("打卡人员账号")
  @TableField("user_account")
  @Column(name = "user_account",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 打卡人员账号 '")
  private String userAccount;

  @ApiModelProperty("打卡用户编码")
  @TableField(value = "user_code")
  @Column(name = "user_code",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 打卡用户编码 '")
  private String userCode;

  @ApiModelProperty("职位编码")
  @TableField(value = "position_code")
  @Column(name = "position_code",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 职位编码 '")
  private String positionCode;

  @ApiModelProperty("职位名称")
  @TableField(value = "position_name")
  @Column(name = "position_name",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 职位编码 '")
  private String positionName;

  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  @Column(name = "org_code",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属组织编码 '")
  private String orgCode;

  @ApiModelProperty("所属组织名称")
  @TableField(value = "org_name")
  @Column(name = "org_name",nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织名称 '")
  private String orgName;

  @ApiModelProperty("排班计划Id")
  @TableField("shift_plan_id")
  @Column(name = "shift_plan_id",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 排班计划Id '")
  private String shiftPlanId;
}
