package com.biz.crm.cps.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * 打卡图片
 * @Author dy
 * @DATE 2022/2/11
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceClockPictureRelationship", description = "打卡图片")
@TableName("attendance_clock_picture_relationship")
@Entity
@javax.persistence.Table(name = "`attendance_clock_picture_relationship`")
@org.hibernate.annotations.Table(appliesTo = "`attendance_clock_picture_relationship`", comment = "打卡图片")
public class AttendanceClockPictureRelationship extends BaseIdEntity {

  @TableField(value = "attendance_clock_id")
  @ApiModelProperty("打卡记录Id")
  @Column(name = "attendance_clock_id",nullable = false,length = 32,columnDefinition = "VARCHAR(32) COMMENT ' 打卡记录ID '")
  private String attendanceClockId;

  @TableField(value = "picture_address")
  @ApiModelProperty("图片地址")
  @Column(name = "picture_address",nullable = false,length = 255,columnDefinition = "VARCHAR(255) COMMENT ' 图片地址 '")
  private String pictureAddress;

  @TableField(value = "picture_name")
  @ApiModelProperty("图片名称")
  @Column(name = "picture_name",nullable = false,length = 255,columnDefinition = "VARCHAR(255) COMMENT ' 图片名称 '")
  private String pictureName;
}
