package com.biz.crm.cps.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 考勤详情结算
 * @Author dy
 * @DATE 2022/2/14
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceDetailSettlement", description = "考勤详情结算")
@TableName("attendance_detail_settlement")
@Entity
@javax.persistence.Table(name = "`attendance_detail_settlement`")
@org.hibernate.annotations.Table(appliesTo = "`attendance_detail_settlement`", comment = "考勤详情结算")
public class AttendanceDetailSettlement extends TenantFlagOpEntity {

  @ApiModelProperty("考勤日期")
  @TableField("attendance_date")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd")
  @Column(name = "attendance_date", nullable = false, columnDefinition = "date COMMENT '考勤日期'")
  private Date attendanceDate;

  @ApiModelProperty("考勤状态")
  @TableField("attendance_status")
  @Column(name = "attendance_status",nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 考勤状态 '")
  private String attendanceStatus;

  @ApiModelProperty("用户姓名")
  @TableField("user_name")
  @Column(name = "user_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 用户姓名 '")
  private String userName;

  @ApiModelProperty("用户账号")
  @TableField("user_account")
  @Column(name = "user_account",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 用户账号 '")
  private String userAccount;

  @ApiModelProperty("用户编码")
  @TableField("user_code")
  @Column(name = "user_code",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 用户编码 '")
  private String userCode;

  @ApiModelProperty("联系电话")
  @TableField(value = "contact_phone")
  @Column(name = "contact_phone",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 联系电话 '")
  private String contactPhone;

  @ApiModelProperty("排班类型")
  @TableField(value = "shift_plan_type")
  @Column(name = "shift_plan_type",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 排班类型 '")
  private String shiftPlanType;

  @ApiModelProperty("职位编码")
  @TableField(value = "position_code")
  @Column(name = "position_code",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 职位编码 '")
  private String positionCode;

  @ApiModelProperty("职位名称")
  @TableField(value = "position_name")
  @Column(name = "position_name",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 职位名称 '")
  private String positionName;

  @ApiModelProperty("所属组织编码")
  @TableField("org_code")
  @Column(name = "org_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属组织编码 '")
  private String orgCode;

  @ApiModelProperty("所属组织名字")
  @TableField("org_name")
  @Column(name = "org_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属组织名字 '")
  private String orgName;

  @ApiModelProperty("排班名称")
  @TableField("shift_plan_name")
  @Column(name = "shift_plan_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 排班名称 '")
  private String shiftPlanName;

  @ApiModelProperty("签到时间")
  @TableField("sign_in_date")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "sign_in_date", nullable = true, columnDefinition = "datetime COMMENT '签到时间'")
  private Date signInDate;

  @ApiModelProperty("签退时间")
  @TableField("sign_back_date")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "sign_back_date", nullable = true, columnDefinition = "datetime COMMENT '签退时间'")
  private Date signBackDate;

  @ApiModelProperty("目标工时")
  @TableField("goal_work_hours")
  @Column(name = "goal_work_hours", nullable = true, columnDefinition = "DECIMAL(20,4) COMMENT ' 目标工时 '")
  private BigDecimal goalWorkHours;

  @ApiModelProperty("实际工时")
  @TableField("real_work_hours")
  @Column(name = "real_work_hours", nullable = true, columnDefinition = "DECIMAL(20,4) COMMENT ' 实际工时 '")
  private BigDecimal realWorkHours;

  @ApiModelProperty("调休时长")
  @TableField(value = "compensatory_leave_length")
  @Column(name = "compensatory_leave_length", nullable = true, columnDefinition = "DECIMAL(20,4) COMMENT ' 实际工时 '")
  private BigDecimal compensatoryLeaveLength;

  @ApiModelProperty("打卡经度")
  @TableField("longitude")
  @Column(name = "longitude",nullable = true,length = 64,columnDefinition = "decimal(12,8) COMMENT ' 打卡经度 '")
  private BigDecimal longitude;

  @ApiModelProperty("打卡纬度")
  @TableField("latitude")
  @Column(name = "latitude",nullable = true,length = 64,columnDefinition = "decimal(12,8) COMMENT ' 打卡纬度 '")
  private BigDecimal latitude;

  @ApiModelProperty("打卡地址编码")
  @TableField(value = "address_code")
  @Column(name = "address_code", length = 32, nullable = true, columnDefinition = "varchar(32) COMMENT '打卡地址编码'")
  private String addressCode;

  @ApiModelProperty("打卡详细地址地址")
  @TableField("address")
  @Column(name = "address",nullable = true,length = 255,columnDefinition = "VARCHAR(255) COMMENT ' 打卡详细地址地址 '")
  private String address;
}
