package com.biz.crm.cps.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.util.Date;


/**
 * 班次管理
 * @Author dy
 * @DATE 2022/2/10
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "attendanceShift", description = "上班班次管理")
@TableName("attendance_shift")
@Entity
@javax.persistence.Table(name = "`attendance_shift`")
@org.hibernate.annotations.Table(appliesTo = "`attendance_shift`", comment = "上班班次管理")
public class AttendanceShift extends TenantFlagOpEntity {

  @ApiModelProperty("班次编码")
  @TableField(value = "shift_code")
  @Column(name = "shift_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 班次编码 '")
  private String shiftCode;

  @ApiModelProperty("班次名称")
  @TableField(value = "shift_name")
  @Column(name = "shift_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 班次名称 '")
  private String shiftName;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftTypeEnum}
   */
  @ApiModelProperty("班次类型")
  @TableField(value = "shift_type")
  @Column(name = "shift_type",nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 班次类型 '")
  private String shiftType;

  @ApiModelProperty("班次描述")
  @TableField(value = "shift_describe")
  @Column(name = "shift_describe",nullable = false, length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 班次描述 '")
  private String shiftDescribe;

  @ApiModelProperty("班次标识颜色")
  @TableField(value = "shift_color")
  @Column(name = "shift_color",nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 班次标识颜色 '")
  private String shiftColor;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.ShoppingGuideSelectMethodEnum}
   */
  @ApiModelProperty("导购选择方式")
  @TableField(value = "shopping_guide_select_method")
  @Column(name = "shopping_guide_select_method",nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 导购选择方式 '")
  private String shoppingGuideSelectMethod;

  @ApiModelProperty("是否跨天班次")
  @TableField(value = "across_day")
  @Column(name = "across_day", nullable = false, length = 1, columnDefinition = "tinyint(1) COMMENT ' 是否跨天班次 '")
  private Boolean acrossDay;

  @ApiModelProperty("工作开始时间")
  @TableField(value = "work_start_time")
  @Column(name = "work_start_time",nullable = false, columnDefinition = "time COMMENT ' 工作开始时间 '")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date workStartTime;

  @ApiModelProperty("最晚签到时间")
  @TableField(value = "latest_sign_in_time")
  @Column(name = "latest_sign_in_time",nullable = true, columnDefinition = "time COMMENT ' 最晚签到时间 '")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date latestSignInTime;

  @ApiModelProperty("工作结束时间")
  @TableField(value = "work_end_time")
  @Column(name = "work_end_time",nullable = false, columnDefinition = "time COMMENT ' 工作结束时间 '")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date workEndTime;

  @ApiModelProperty("最早签退时间")
  @TableField(value = "earliest_sign_back_time")
  @Column(name = "earliest_sign_back_time",nullable = true,columnDefinition = "time COMMENT ' 最早签退时间 '")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date earliestSignBackTime;
}
