package com.biz.crm.cps.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.util.Date;

/**
 * 排班申请
 * @Author dy
 * @DATE 2022/2/10
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "attendanceShiftApplication", description = "排班申请")
@TableName("attendance_shift_application")
@Entity
@javax.persistence.Table(name = "`attendance_shift_application`")
@org.hibernate.annotations.Table(appliesTo = "`attendance_shift_application`", comment = "排班申请")
public class AttendanceShiftApplication extends TenantFlagOpEntity {

  @ApiModelProperty("排班申请编码")
  @TableField(value = "apply_code")
  @Column(name = "apply_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 排班申请编码 '")
  private String applyCode;

  @ApiModelProperty("发起申请时间")
  @TableField(value = "apply_date")
  @Column(name = "apply_date", nullable = false, columnDefinition = "datetime COMMENT '发起申请时间'")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  private Date applyDate;

  @ApiModelProperty("申请排班开始时间")
  @TableField(value = "apply_start_date")
  @Column(name = "apply_start_date", nullable = false, columnDefinition = "datetime COMMENT '申请排班开始时间'")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  private Date applyStartDate;

  @ApiModelProperty("申请排班结束时间")
  @TableField(value = "apply_end_date")
  @Column(name = "apply_end_date", nullable = false, columnDefinition = "datetime COMMENT '申请排班结束时间'")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  private Date applyEndDate;

  @ApiModelProperty("审核时间")
  @TableField(value = "audit_date")
  @Column(name = "audit_date", nullable = true, columnDefinition = "datetime COMMENT '审核时间'")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  private Date auditDate;

  @ApiModelProperty("申请周期(年份+周数)如 202201")
  @TableField(value = "apply_period")
  @Column(name = "apply_period",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 申请周期(年份+周数)如 202201 '")
  private String applyPeriod;

  @ApiModelProperty("联系电话")
  @TableField(value = "contact_phone")
  @Column(name = "contact_phone",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 联系电话 '")
  private String contactPhone;

  @ApiModelProperty("申请排班用户编码")
  @TableField(value = "user_code")
  @Column(name = "user_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 申请排班用户编码 '")
  private String userCode;

  @ApiModelProperty("申请排班用户账号")
  @TableField(value = "user_account")
  @Column(name = "user_account",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 申请排班用户账号 '")
  private String userAccount;

  @ApiModelProperty("申请排班用户名称")
  @TableField(value = "user_name")
  @Column(name = "user_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 申请排班用户名称 '")
  private String userName;

  @Column(name = "user_type",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 申请排班用户类型 '")
  @ApiModelProperty("申请排班用户类型")
  @TableField(value = "user_type")
  private String userType;

  @Column(name = "org_code",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属组织编码 '")
  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  private String orgCode;

  @Column(name = "org_name",nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织名称 '")
  @ApiModelProperty("所属组织名称")
  @TableField(value = "org_name")
  private String orgName;

  @ApiModelProperty("审核状态")
  @TableField(value = "audit_status")
  @Column(name = "audit_status",nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 审核状态 '")
  private String auditStatus;

  @ApiModelProperty("驳回原因")
  @TableField(value = "rejected_reason")
  @Column(name = "rejected_reason",nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 驳回原因 '")
  private String rejectedReason;
}
