package com.biz.crm.cps.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * 班次与导购所属组织关联关系
 * @Author dy
 * @DATE 2022/2/15
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceShiftOrganizationRelationship", description = "班次与导购所属组织关联关系")
@TableName("attendance_shift_organization_relationship")
@Entity
@javax.persistence.Table(name = "`attendance_shift_organization_relationship`")
@org.hibernate.annotations.Table(appliesTo = "`attendance_shift_organization_relationship`", comment = "班次与导购所属组织关联关系")
public class AttendanceShiftOrganizationRelationship extends BaseIdEntity {

  /**
   * 班次编码
   */
  @Column(name = "shift_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 班次编码 '")
  @ApiModelProperty("班次编码")
  @TableField(value = "shift_code")
  private String shiftCode;

  /**
   * 所属组织编码
   */
  @Column(name = "org_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属组织编码 '")
  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @Column(name = "org_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织名称 '")
  @ApiModelProperty("所属组织名称")
  @TableField(value = "org_name")
  private String orgName;
}
