package com.biz.crm.cps.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 排班计划详情
 * @Author dy
 * @DATE 2022/2/10
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "attendanceShiftPlan", description = "排班申请计划详情")
@TableName("attendance_shift_plan")
@Entity
@javax.persistence.Table(name = "`attendance_shift_plan`")
@org.hibernate.annotations.Table(appliesTo = "`attendance_shift_plan`", comment = "排班申请计划详情")
public class AttendanceShiftPlan extends TenantOpEntity {

  @ApiModelProperty("排班日期")
  @TableField("scheduling_date")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  @Column(name = "scheduling_date", nullable = false, columnDefinition = "date COMMENT '排班日期'")
  private Date schedulingDate;

  @ApiModelProperty("是否是有效日期,即排班日期是否在申请日期之前")
  @TableField(value = "effective_date")
  @Column(name = "effective_date",nullable = false,length = 1,columnDefinition = "tinyint(1) COMMENT ' 是否是有效日期 '")
  private Boolean effectiveDate;

  @ApiModelProperty("排班申请编码")
  @TableField(value = "apply_code")
  @Column(name = "apply_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 排班申请编码 '")
  private String applyCode;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftPlanTypeEnum}
   */
  @ApiModelProperty("排班类型")
  @TableField(value = "shift_plan_type")
  @Column(name = "shift_plan_type",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 排班类型 '")
  private String shiftPlanType;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftTypeEnum}
   */
  @ApiModelProperty("班次类型")
  @TableField(value = "shift_type")
  @Column(name = "shift_type",nullable = true, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 班次类型 '")
  private String shiftType;

  @ApiModelProperty("班次编码")
  @TableField(value = "shift_code")
  @Column(name = "shift_code",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 班次编码 '")
  private String shiftCode;

  @ApiModelProperty("班次名称")
  @TableField(value = "shift_name")
  @Column(name = "shift_name",nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 班次名称 '")
  private String shiftName;

  @ApiModelProperty("班次描述")
  @TableField(value = "shift_describe")
  @Column(name = "shift_describe",nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 班次描述 '")
  private String shiftDescribe;

  @ApiModelProperty("班次标识颜色")
  @TableField(value = "shift_color")
  @Column(name = "shift_color",nullable = true, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 班次标识颜色 '")
  private String shiftColor;

  @ApiModelProperty("是否跨天班次")
  @TableField(value = "across_day")
  @Column(name = "across_day", nullable = true, length = 1, columnDefinition = "tinyint(1) COMMENT ' 是否跨天班次 '")
  private Boolean acrossDay;

  @ApiModelProperty("是否是节假日")
  @TableField(value = "holiday")
  @Column(name = "holiday",nullable = false,length = 1,columnDefinition = "tinyint(1) COMMENT ' 是否是节假日 '")
  private Boolean holiday;

  @ApiModelProperty("节日名称")
  @TableField(value = "festival_name")
  @Column(name = "festival_name",nullable = true,length = 64,columnDefinition = "VARCHAR(64) COMMENT ' 节日名称 '")
  private String festivalName;

  @ApiModelProperty("星期")
  @TableField(value = "week")
  @Column(name = "week",nullable = false,length = 11,columnDefinition = "int(11) COMMENT ' 星期 '")
  private Integer week;

  @ApiModelProperty("上班时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField("work_start_date")
  @Column(name = "work_start_date", nullable = true, columnDefinition = "datetime COMMENT '上班时间'")
  private Date workStartDate;

  @ApiModelProperty("最晚签到时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField(value = "latest_sign_in_date")
  @Column(name = "latest_sign_in_date", nullable = true, columnDefinition = "datetime COMMENT '最晚签到时间'")
  private Date latestSignInDate;

  @ApiModelProperty("下班时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField("work_end_date")
  @Column(name = "work_end_date", nullable = true, columnDefinition = "datetime COMMENT '下班时间'")
  private Date workEndDate;

  @ApiModelProperty("最早签退时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField(value = "earliest_sign_back_date")
  @Column(name = "earliest_sign_back_date", nullable = true, columnDefinition = "datetime COMMENT '最早签退时间'")
  private Date earliestSignBackDate;

  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", nullable = true, length = 64,columnDefinition = "VARCHAR(64) COMMENT '终端编码'")
  private String terminalCode;

  @ApiModelProperty("终端名称")
  @TableField(value = "terminal_name")
  @Column(name = "terminal_name", nullable = true, length = 255,columnDefinition = "VARCHAR(255) COMMENT '终端名称'")
  private String terminalName;

  @ApiModelProperty("终端类型")
  @TableField(value = "terminal_type")
  @Column(name = "terminal_type", nullable = true, length = 64,columnDefinition = "VARCHAR(64) COMMENT '终端名称'")
  private String terminalType;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.CompensatoryLeaveTypeEnum}
   */
  @ApiModelProperty("调休类型")
  @TableField(value = "compensatory_leave_type")
  @Column(name = "compensatory_leave_type", nullable = true, columnDefinition = "VARCHAR(16) COMMENT '调休类型'")
  private String compensatoryLeaveType;

  @ApiModelProperty("调休开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField("compensatory_leave_start_date")
  @Column(name = "compensatory_leave_start_date", nullable = true, columnDefinition = "datetime COMMENT '调休开始时间'")
  private Date compensatoryLeaveStartDate;

  @ApiModelProperty("调休结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField("compensatory_leave_end_date")
  @Column(name = "compensatory_leave_end_date", nullable = true, columnDefinition = "datetime COMMENT '调休结束时间'")
  private Date compensatoryLeaveEndDate;

  @ApiModelProperty("调休时长")
  @TableField(value = "compensatory_leave_length")
  @Column(name = "compensatory_leave_length", nullable = true, columnDefinition = "DECIMAL(20,4) COMMENT ' 调休时长 '")
  private BigDecimal compensatoryLeaveLength;

  @ApiModelProperty("正常工作时长")
  @TableField(value = "normal_work_hours")
  @Column(name = "normal_work_hours", nullable = true, columnDefinition = "DECIMAL(20,4) COMMENT ' 正常工作时长 '")
  private BigDecimal normalWorkHours;
}
