package com.biz.crm.cps.business.attendance.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * @Author dy
 * @DATE 2022/2/11
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AttendanceShiftUserRelationship", description = "班次导购关联对象")
@TableName("attendance_shift_user_relationship")
@Entity
@javax.persistence.Table(name = "`attendance_shift_user_relationship`")
@org.hibernate.annotations.Table(appliesTo = "`attendance_shift_user_relationship`", comment = "班次导购关联对象")
public class AttendanceShiftUserRelationship extends BaseIdEntity {

  @ApiModelProperty("班次编码")
  @TableField(value = "shift_code")
  @Column(name = "shift_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 班次编码 '")
  private String shiftCode;

  @ApiModelProperty("导购用户编码")
  @TableField(value = "user_code")
  @Column(name = "user_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 导购用户编码 '")
  private String userCode;

  @ApiModelProperty("导购用户名称")
  @TableField(value = "user_name")
  @Column(name = "user_name",nullable = false, length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 导购用户名称 '")
  private String userName;


  @ApiModelProperty("导购用户账号")
  @TableField(value = "user_account")
  @Column(name = "user_account",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 申请排班用户账号 '")
  private String userAccount;

  @Column(name = "user_type",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 申请排班用户类型 '")
  @ApiModelProperty("申请排班用户类型")
  @TableField(value = "user_type")
  private String userType;

  /**
   * 所属组织编码
   */
  @Column(name = "org_code",nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属组织编码 '")
  @ApiModelProperty("导购所属组织编码")
  @TableField(value = "org_code")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @Column(name = "org_name",nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织名称 '")
  @ApiModelProperty("导购所属组织名称")
  @TableField(value = "org_name")
  private String orgName;
}
