package com.biz.crm.cps.business.attendance.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceClock;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockConditionDto;
import org.apache.ibatis.annotations.Param;

/**
 * 考勤打卡明细(AttendanceClock)表mybatis访问层
 *
 * @author dy
 * @since 2022-03-07 10:29:41
 */
public interface AttendanceClockMapper extends BaseMapper<AttendanceClock> {

  /**
   * 分页查询所有数据
   *
   * @param page            分页对象
   * @param dto 查询实体
   * @return 所有数据
   */
  Page<AttendanceClock> findByConditions(@Param("page") Page<AttendanceClock> page, @Param("dto") AttendanceClockConditionDto dto);
}

