package com.biz.crm.cps.business.attendance.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftApplication;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import org.apache.ibatis.annotations.Param;

/**
 * 排班申请(ShiftApplication)表mybatis访问层
 *
 * @author dy
 * @since 2022-02-16 14:55:15
 */
public interface AttendanceShiftApplicationMapper extends BaseMapper<AttendanceShiftApplication> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param dto  查询条件实体
   * @return 所有数据
   */
  public Page<AttendanceShiftApplication> findByConditions(@Param("page") Page<AttendanceShiftApplication> page, @Param("dto") ShiftApplicationConditionDto dto);
}

