package com.biz.crm.cps.business.attendance.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftApplication;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftPlan;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftApplicationVo;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftPlanVo;
import org.apache.ibatis.annotations.Param;

import java.util.Date;

/**
 * 排班申请计划详情Vo(ShiftPlanVo)mybatis访问层
 *
 * @Author dy
 * @DATE 2022/2/21
 **/
public interface AttendanceShiftApplicationVoMapper {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param dto  查询实体
   * @return 所有数据
   */
  Page<AttendanceShiftApplicationVo> findDetailsByConditions(@Param("page") Page<AttendanceShiftApplicationVo> page, @Param("dto") ShiftApplicationConditionDto dto);

  /**
   * 根据Id查询申请详情(包含关联数据）
   *
   * @param id
   * @return
   */
  AttendanceShiftApplicationVo findDetailsById(@Param("id") String id);

  /**
   * 根据编码查询申请详情(包含关联数据)
   *
   * @param applyCode
   * @return
   */
  AttendanceShiftApplicationVo findDetailsByApplyCode(@Param("applyCode") String applyCode);

  /**
   * 根据用户账号和申请周期查询
   * @param userAccount
   * @param applyPeriod
   * @return
   */
  AttendanceShiftApplicationVo findByUserAccountAndApplyPeriod(@Param("userAccount")String userAccount, @Param("applyPeriod")String applyPeriod);
}
