package com.biz.crm.cps.business.attendance.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShift;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import org.apache.ibatis.annotations.Param;

/**
 * 上班班次管理(WorkShift)表mybatis访问层
 *
 * @author dy
 * @since 2022-02-16 15:40:38
 */
public interface AttendanceShiftMapper extends BaseMapper<AttendanceShift> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param dto  查询条件实体
   * @return 所有数据
   */
  Page<AttendanceShift> findByConditions(@Param("page") Page<AttendanceShift> page, @Param("dto") ShiftConditionDto dto);
}

