package com.biz.crm.cps.business.attendance.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftPlan;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 排班申请计划详情(ShiftPlan)表mybatis访问层
 *
 * @author makejava
 * @since 2022-02-16 15:35:27
 */
public interface AttendanceShiftPlanMapper extends BaseMapper<AttendanceShiftPlan> {

  /**
   * 分页查询所有数据
   *
   * @param page                分页对象
   * @param attendanceShiftPlan 查询实体
   * @return 所有数据
   */
  public Page<AttendanceShiftPlan> findByConditions(@Param("page") Page<AttendanceShiftPlan> page, @Param("shiftPlan") AttendanceShiftPlan attendanceShiftPlan);

  /**
   * 根据用户账号和排班日期查询
   * @param userAccount
   * @param schedulingDate
   * @return
   */
  public AttendanceShiftPlan findByUserAccountAndSchedulingDate(@Param("userAccount")String userAccount, @Param("schedulingDate") Date schedulingDate);

  /**
   * 根据排班日期和审核状态查询
   * @param schedulingDate
   * @param auditStatus
   * @return
   */
  public List<AttendanceShiftPlan> findBySchedulingDateAndAuditStatus(@Param("schedulingDate")Date schedulingDate,@Param("auditStatus")String auditStatus);
}

