package com.biz.crm.cps.business.attendance.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShift;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftVo;
import org.apache.ibatis.annotations.Param;

/**
 * 上班班次管理Vo(AttendanceShiftVo)表mybatis访问层
 *
 * @Author dy
 * @DATE 2022/2/21
 **/
public interface AttendanceShiftVoMapper {

  /**
   * 分页查询所有数据(包括关联数据)
   *
   * @param page 分页对象
   * @param dto  查询条件实体
   * @return 所有数据
   */
  Page<AttendanceShiftVo> findDetailsByConditions(@Param("page") Page<AttendanceShiftVo> page, @Param("dto") ShiftConditionDto dto);

  /**
   * 根据id查询详情(包含关联数据)
   *
   * @param id
   * @return
   */
  AttendanceShiftVo findDetailsById(@Param("id") String id);

  /**
   * 根据编码查询详情(包含关联数据)
   *
   * @param shiftCode
   * @return
   */
  AttendanceShiftVo findDetailsByShiftCode(@Param("shiftCode") String shiftCode);
}
