package com.biz.crm.cps.business.attendance.local.repository;

import com.biz.crm.cps.business.attendance.local.entity.AttendanceClockPictureRelationship;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceClockPictureRelationshipMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 打卡图片(AttendanceClockPictureRelationship)表数据库访问层
 *
 * @author dy
 * @since 2022-03-07 10:29:42
 */
@Component
public class AttendanceClockPictureRelationshipRepository extends ServiceImpl<AttendanceClockPictureRelationshipMapper, AttendanceClockPictureRelationship> {

  @Autowired
  private AttendanceClockPictureRelationshipMapper attendanceClockPictureRelationshipMapper;

  /**
   * 根据打卡记录Id删除图片
   * @param attendanceClockId
   */
  public void deleteByAttendanceClockId(String attendanceClockId){
    this.lambdaUpdate().eq(AttendanceClockPictureRelationship::getAttendanceClockId,attendanceClockId).remove();
  }
}

