package com.biz.crm.cps.business.attendance.local.repository;

import com.biz.crm.cps.business.attendance.local.entity.AttendanceClock;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceClockMapper;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockConditionDto;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;


/**
 * 考勤打卡明细(AttendanceClock)表数据库访问层
 *
 * @author dy
 * @since 2022-03-07 10:29:41
 */
@Component
public class AttendanceClockRepository extends ServiceImpl<AttendanceClockMapper, AttendanceClock> {

  @Autowired
  private AttendanceClockMapper attendanceClockMapper;

  /**
   * 分页查询数据
   *
   * @param pageable        分页对象
   * @param dto 实体对象
   * @return
   */
  public Page<AttendanceClock> findByConditions(Pageable pageable, AttendanceClockConditionDto dto) {
    Page<AttendanceClock> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AttendanceClock> pageList = attendanceClockMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据用户账号，考勤日期，打卡类型查找
   * @param userAccount
   * @param attendanceDate
   * @param clockType
   * @return
   */
  public AttendanceClock findByUserAccountAndAttendanceDateAndClockType(String userAccount, Date attendanceDate,String clockType){
    return this.lambdaQuery().eq(AttendanceClock::getUserAccount,userAccount)
        .eq(AttendanceClock::getAttendanceDate,attendanceDate)
        .eq(AttendanceClock::getClockType,clockType)
        .one();
  }

  /**
   * 根据排班计划Id查询
   * @param shiftPlanId
   * @return
   */
  public List<AttendanceClock> findByShiftPlanId(String shiftPlanId){
    return this.lambdaQuery().eq(AttendanceClock::getShiftPlanId,shiftPlanId).list();
  }
}

