package com.biz.crm.cps.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceClockVoMapper;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockConditionDto;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceClockVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 考勤打卡明细(AttendanceClockVo)表数据库访问层
 * @Author dy
 * @DATE 2022/3/15
 **/
@Component
public class AttendanceClockVoRepository {

  @Autowired
  private AttendanceClockVoMapper attendanceClockVoMapper;

  /**
   * 分页条件查询打卡信息
   * @param pageable 分页信息
   * @param dto 分页查询dto
   * @return 分页返回信息
   */
  public Page<AttendanceClockVo> findByConditions(Pageable pageable, AttendanceClockConditionDto dto){
    Page<AttendanceClockVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AttendanceClockVo> pageList = this.attendanceClockVoMapper.findByConditions(page, dto);
    return pageList;
  }
}
