package com.biz.crm.cps.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceDetailReportVoMapper;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceDetailReportConditionDto;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceDetailReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 考勤报表(AttendanceDetailReportVo)表数据库访问层
 * @Author dy
 * @DATE 2022/3/3
 **/
@Component
public class AttendanceDetailReportVoRepository {

  @Autowired
  private AttendanceDetailReportVoMapper attendanceDetailReportVoMapper;

  /**
   * 分页返回所有数据
   * @param pageable
   * @param dto
   * @return
   */
  public Page<AttendanceDetailReportVo> findByConditions(Pageable pageable, AttendanceDetailReportConditionDto dto){
    Page<AttendanceDetailReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AttendanceDetailReportVo> pageList = attendanceDetailReportVoMapper.findByConditions(page, dto);
    return pageList;
  }
}
