package com.biz.crm.cps.business.attendance.local.repository;


import com.biz.crm.cps.business.attendance.local.entity.AttendanceDetailSettlement;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceDetailSettlementMapper;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceDetailConditionDto;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.Date;


/**
 * 考勤详情结算(AttendanceDetailSettlement)表数据库访问层
 *
 * @author dy
 * @since 2022-03-03 17:36:14
 */
@Component
public class AttendanceDetailSettlementRepository extends ServiceImpl<AttendanceDetailSettlementMapper, AttendanceDetailSettlement> {

  @Autowired
  private AttendanceDetailSettlementMapper attendanceDetailSettlementMapper;

  /**
   * 分页查询数据
   *
   * @param pageable                   分页对象
   * @param dto 查询条件实体对象
   * @return
   */
  public Page<AttendanceDetailSettlement> findByConditions(Pageable pageable, AttendanceDetailConditionDto dto) {
    Page<AttendanceDetailSettlement> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AttendanceDetailSettlement> pageList = attendanceDetailSettlementMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据考勤日期和用户账号删除
   * @param attendanceDate
   */
  public void deleteByAttendanceDate(Date attendanceDate){
    this.lambdaUpdate().eq(AttendanceDetailSettlement::getAttendanceDate,attendanceDate)
        .remove();
  }
}

