package com.biz.crm.cps.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftApplication;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceShiftApplicationMapper;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 排班申请(ShiftApplication)表数据库访问层
 *
 * @author makejava
 * @since 2022-02-16 14:55:15
 */
@Component
public class AttendanceShiftApplicationRepository extends ServiceImpl<AttendanceShiftApplicationMapper, AttendanceShiftApplication> {

  @Autowired
  private AttendanceShiftApplicationMapper attendanceShiftApplicationMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param dto 查询条件对象
   * @return
   */
  public Page<AttendanceShiftApplication> findByConditions(Pageable pageable, ShiftApplicationConditionDto dto) {
    Page<AttendanceShiftApplication> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AttendanceShiftApplication> pageList = attendanceShiftApplicationMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据Id查找排班申请
   * @param id
   * @return
   */
  public AttendanceShiftApplication findById(String id){
    return this.lambdaQuery().eq(AttendanceShiftApplication::getId,id).one();
  }

  /**
   * 根据申请编码查询
   * @param applyCode
   * @return
   */
  public AttendanceShiftApplication findByApplyCode(String applyCode){
    return this.lambdaQuery().eq(AttendanceShiftApplication::getApplyCode,applyCode).one();
  }

  /**
   * 通过用户编码合申请周期查询
   * @param userAccount
   * @param applyPeriod
   * @return
   */
  public AttendanceShiftApplication findByUserAccountAndApplyPeriod(String userAccount,String applyPeriod){
    return this.lambdaQuery().eq(AttendanceShiftApplication::getUserAccount,userAccount)
        .eq(AttendanceShiftApplication::getApplyPeriod,applyPeriod).one();
  }

  /**
   * 根据Id列表查询
   * @param ids
   * @return
   */
  public List<AttendanceShiftApplication> findByIds(List<String> ids){
    return this.lambdaQuery().in(AttendanceShiftApplication::getId,ids).list();
  }
}

