package com.biz.crm.cps.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftApplication;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceShiftApplicationMapper;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceShiftApplicationVoMapper;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftApplicationVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.AccessType;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 排班申请Vo(AttendanceShiftApplicationVo)表数据库访问层
 * @Author dy
 * @DATE 2022/2/21
 **/
@Component
public class AttendanceShiftApplicationVoRepository {

  @Autowired
  private AttendanceShiftApplicationVoMapper attendanceShiftApplicationVoMapper;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param dto 查询条件对象
   * @return
   */
  public Page<AttendanceShiftApplicationVo> findDetailsByConditions(Pageable pageable, ShiftApplicationConditionDto dto) {
    Page<AttendanceShiftApplicationVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AttendanceShiftApplicationVo> pageList = attendanceShiftApplicationVoMapper.findDetailsByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据Id查询申请详情(包含关联数据)
   * @param id
   * @return
   */
  public AttendanceShiftApplicationVo findDetailsById(String id){
    return this.attendanceShiftApplicationVoMapper.findDetailsById(id);
  }

  /**
   * 根据编码查询申请详情(包含关联数据)
   * @param applyCode
   * @return
   */
  public AttendanceShiftApplicationVo findDetailsByApplyCode(String applyCode){
    return this.attendanceShiftApplicationVoMapper.findDetailsByApplyCode(applyCode);
  }

  /**
   * 根据用户账号和申请周期查询详情
   * @param userAccount
   * @param applyPeriod
   * @return
   */
  public AttendanceShiftApplicationVo findByUserAccountAndApplyPeriod(String userAccount,String applyPeriod){
    return this.attendanceShiftApplicationVoMapper.findByUserAccountAndApplyPeriod(userAccount, applyPeriod);
  }
}
