package com.biz.crm.cps.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftOrganizationRelationship;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceShiftOrganizationRelationshipMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 班次与导购所属组织关联关系(ShiftOrganizationRelationship)表数据库访问层
 *
 * @author makejava
 * @since 2022-02-16 15:37:44
 */
@Component
public class AttendanceShiftOrganizationRelationshipRepository extends ServiceImpl<AttendanceShiftOrganizationRelationshipMapper, AttendanceShiftOrganizationRelationship> {

  @Autowired
  private AttendanceShiftOrganizationRelationshipMapper attendanceShiftOrganizationRelationshipMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param attendanceShiftOrganizationRelationship 实体对象
   * @return
   */
  public Page<AttendanceShiftOrganizationRelationship> findByConditions(Pageable pageable, AttendanceShiftOrganizationRelationship attendanceShiftOrganizationRelationship) {
    Page<AttendanceShiftOrganizationRelationship> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AttendanceShiftOrganizationRelationship> pageList = attendanceShiftOrganizationRelationshipMapper.findByConditions(page, attendanceShiftOrganizationRelationship);
    return pageList;
  }

  /**
   * 根据班次编码删除关联信息
   * @param shiftCode
   */
  public void deleteByShiftCode(String shiftCode){
    this.lambdaUpdate().eq(AttendanceShiftOrganizationRelationship::getShiftCode,shiftCode).remove();
  }

  /**
   * 根据班次编码查询
   * @param shiftCode
   * @return
   */
  public List<AttendanceShiftOrganizationRelationship> findByShiftCode(String shiftCode){
    return this.lambdaQuery().eq(AttendanceShiftOrganizationRelationship::getShiftCode,shiftCode).list();
  }
}

