package com.biz.crm.cps.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftPlan;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceShiftPlanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;


/**
 * 排班申请计划详情(ShiftPlan)表数据库访问层
 *
 * @author makejava
 * @since 2022-02-16 15:35:27
 */
@Component
public class AttendanceShiftPlanRepository extends ServiceImpl<AttendanceShiftPlanMapper, AttendanceShiftPlan> {

  @Autowired
  private AttendanceShiftPlanMapper attendanceShiftPlanMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param attendanceShiftPlan 实体对象
   * @return
   */
  public Page<AttendanceShiftPlan> findByConditions(Pageable pageable, AttendanceShiftPlan attendanceShiftPlan) {
    Page<AttendanceShiftPlan> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AttendanceShiftPlan> pageList = attendanceShiftPlanMapper.findByConditions(page, attendanceShiftPlan);
    return pageList;
  }

  /**
   * 根据申请编码删除
   * @param applyCode
   */
  public void deleteByApplyCode(String applyCode){
    this.lambdaUpdate().eq(AttendanceShiftPlan::getApplyCode,applyCode).remove();
  }

  /**
   * 根据申请编码和排班时间查询排班详情
   * @param applyCode
   * @param schedulingDate
   * @return
   */
  public AttendanceShiftPlan findByApplyCodeAndSchedulingDate(String applyCode, @DateTimeFormat(pattern = "yyyy-MM-dd") Date schedulingDate){
    return this.lambdaQuery().eq(AttendanceShiftPlan::getApplyCode,applyCode)
        .eq(AttendanceShiftPlan::getSchedulingDate,schedulingDate)
        .one();
  }

  /**
   * 按照用户账号和排班日期查询
   * @param userAccount
   * @param schedulingDate
   * @return
   */
  public AttendanceShiftPlan findByUserAccountAndSchedulingDate(String userAccount,@DateTimeFormat(pattern = "yyyy-MM-dd") Date schedulingDate){
    return attendanceShiftPlanMapper.findByUserAccountAndSchedulingDate(userAccount,schedulingDate);
  }

  /**
   * 按照用户账号和排班日期查询
   * @param auditStatus
   * @param schedulingDate
   * @return
   */
  public List<AttendanceShiftPlan> findBySchedulingDateAndAuditStatus(String auditStatus, @DateTimeFormat(pattern = "yyyy-MM-dd") Date schedulingDate){
    return attendanceShiftPlanMapper.findBySchedulingDateAndAuditStatus(schedulingDate, auditStatus);
  }
}

