package com.biz.crm.cps.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShift;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceShiftMapper;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 上班班次管理(WorkShift)表数据库访问层
 *
 * @author makejava
 * @since 2022-02-16 15:40:38
 */
@Component
public class AttendanceShiftRepository extends ServiceImpl<AttendanceShiftMapper, AttendanceShift> {

  @Autowired
  private AttendanceShiftMapper attendanceShiftMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param dto 实体对象
   * @return
   */
  public Page<AttendanceShift> findByConditions(Pageable pageable, ShiftConditionDto dto) {
    Page<AttendanceShift> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AttendanceShift> pageList = attendanceShiftMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据id查询班次
   * @param id
   * @return
   */
  public AttendanceShift findById(String id){
    return this.lambdaQuery().eq(AttendanceShift::getId,id).one();
  }

  /**
   * 根据编码查询班次
   * @param shiftCode
   * @return
   */
  public AttendanceShift findByShiftCode(String shiftCode){
    return this.lambdaQuery().eq(AttendanceShift::getShiftCode,shiftCode).one();
  }

  /**
   * 根据班次类型查询班次
   * @param shiftType
   * @return
   */
  public List<AttendanceShift> findByShiftTypeAndEnable(String shiftType){
    return this.lambdaQuery().eq(AttendanceShift::getShiftType,shiftType)
        .eq(AttendanceShift::getEnableStatus,EnableStatusEnum.ENABLE.getCode())
        .list();
  }

  /**
   * 根据班次类型查询班次排除指定id
   * @param shiftType
   * @param id
   * @return
   */
  public List<AttendanceShift> findByShiftTypeAndEnableAndIdNot(String shiftType, String id){
    return this.lambdaQuery().eq(AttendanceShift::getShiftType,shiftType)
        .ne(AttendanceShift::getId,id)
        .eq(AttendanceShift::getEnableStatus,EnableStatusEnum.ENABLE.getCode())
        .list();
  }

  /**
   * 根据导购选择方式查询已启用的班次
   * @param shoppingGuideSelectMethod
   * @return
   */
  public List<AttendanceShift> findByShoppingGuideSelectMethodAndEnable(String shoppingGuideSelectMethod){
    return this.lambdaQuery().eq(AttendanceShift::getShoppingGuideSelectMethod,shoppingGuideSelectMethod)
        .eq(AttendanceShift::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .list();
  }
}

