package com.biz.crm.cps.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftUserRelationship;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceShiftUserRelationshipMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 班次导购关联对象(ShiftShoppingGuideRelationship)表数据库访问层
 *
 * @author dy
 * @since 2022-02-16 15:37:45
 */
@Component
public class AttendanceShiftUserRelationshipRepository extends ServiceImpl<AttendanceShiftUserRelationshipMapper, AttendanceShiftUserRelationship> {

  @Autowired
  private AttendanceShiftUserRelationshipMapper attendanceShiftUserRelationshipMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param attendanceShiftUserRelationship 实体对象
   * @return
   */
  public Page<AttendanceShiftUserRelationship> findByConditions(Pageable pageable, AttendanceShiftUserRelationship attendanceShiftUserRelationship) {
    Page<AttendanceShiftUserRelationship> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AttendanceShiftUserRelationship> pageList = attendanceShiftUserRelationshipMapper.findByConditions(page, attendanceShiftUserRelationship);
    return pageList;
  }

  /**
   * 根据班次编码删除
   * @param shiftCode
   */
  public void deleteByShiftCode(String shiftCode){
    this.lambdaUpdate().eq(AttendanceShiftUserRelationship::getShiftCode,shiftCode).remove();
  }

  /**
   * 根据班次编码查询
   * @param shiftCode
   * @return
   */
  public List<AttendanceShiftUserRelationship> findByShiftCode(String shiftCode){
    return this.lambdaQuery().eq(AttendanceShiftUserRelationship::getShiftCode,shiftCode).list();
  }
}

