package com.biz.crm.cps.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceShiftVoMapper;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 上班班次管理VO(AttendanceShiftVo)表数据库访问层
 * @Author dy
 * @DATE 2022/2/21
 **/
@Component
public class AttendanceShiftVoRepository {

  @Autowired
  private AttendanceShiftVoMapper attendanceShiftVoMapper;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param dto 实体对象
   * @return
   */
  public Page<AttendanceShiftVo> findDetailsByConditions(Pageable pageable, ShiftConditionDto dto) {
    Page<AttendanceShiftVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AttendanceShiftVo> pageList = attendanceShiftVoMapper.findDetailsByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据班次Id查询班次详情，包括关联数据
   * @param id
   * @return
   */
  public AttendanceShiftVo findDetailsById(String id){
    AttendanceShiftVo attendanceShiftVo = attendanceShiftVoMapper.findDetailsById(id);
    return attendanceShiftVo;
  }

  /**
   * 根据班次编码查询班次详情，包括关联数据
   * @param shiftCode
   * @return
   */
  public AttendanceShiftVo findDetailsByShiftCode(String shiftCode){
    AttendanceShiftVo attendanceShiftVo = attendanceShiftVoMapper.findDetailsByShiftCode(shiftCode);
    return attendanceShiftVo;
  }
}
