package com.biz.crm.cps.business.attendance.local.service;

import com.biz.crm.cps.business.attendance.local.entity.AttendanceClock;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockConditionDto;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 考勤打卡明细(AttendanceClock)表服务接口
 *
 * @author dy
 * @since 2022-03-07 10:29:40
 */
public interface AttendanceClockService {

  /**
   * 分页查询数据
   *
   * @param pageable        分页对象
   * @param dto 实体对象
   * @return
   */
  Page<AttendanceClock> findByConditions(Pageable pageable, AttendanceClockConditionDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  AttendanceClock findById(String id);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 打卡
   * @param attendanceClockDto
   * @return
   */
  AttendanceClock create(AttendanceClockDto attendanceClockDto);

  /**
   * 处理上班打卡信息
   * @param attendanceClock
   */
  void handleClockIn(AttendanceClock attendanceClock);

  /**
   * 处理下班打卡信息
   * @param attendanceClock
   */
  void handleClockOut(AttendanceClock attendanceClock);

  /**
   * 根据排班计划详情id查询
   * @param shiftPlanId
   * @return
   */
  List<AttendanceClock> findByShiftPlanId(String shiftPlanId);
}

