package com.biz.crm.cps.business.attendance.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceDetailSettlement;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceDetailConditionDto;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

/**
 * 考勤详情结算(AttendanceDetailSettlement)表服务接口
 *
 * @author dy
 * @since 2022-03-03 17:36:14
 */
public interface AttendanceDetailSettlementService {

  /**
   * 分页查询数据
   *
   * @param pageable                   分页对象
   * @param dto 查询条件实体对象
   * @return
   */
  Page<AttendanceDetailSettlement> findByConditions(Pageable pageable, AttendanceDetailConditionDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  AttendanceDetailSettlement findById(String id);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 生成指定日期的考勤报表数据
   * @param date
   */
  void hanlderAttendanceReportByDate(Date date);
}

