package com.biz.crm.cps.business.attendance.local.service;

import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftApplication;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftApplicationApproveDto;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftApplicationDto;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

/**
 * 排班申请(ShiftApplication)表服务接口
 *
 * @author dy
 * @since 2022-02-16 14:55:15
 */
public interface AttendanceShiftApplicationService {

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param dto 查询条件对象
   * @return
   */
  Page<AttendanceShiftApplication> findByConditions(Pageable pageable, ShiftApplicationConditionDto dto);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  AttendanceShiftApplication findById(String id);
  
   /**
   * 新增数据
   * @param attendanceShiftApplicationDto 实体对象
   * @return 新增结果
   */
  AttendanceShiftApplication create(AttendanceShiftApplicationDto attendanceShiftApplicationDto);

  /**
   * 新增数据
   * @param attendanceShiftApplication
   * @return
   */
  AttendanceShiftApplication createForm(AttendanceShiftApplication attendanceShiftApplication);
  
   /**
   * 修改新据
   * @param attendanceShiftApplicationDto 实体对象
   * @return 修改结果
   */
  AttendanceShiftApplication update(AttendanceShiftApplicationDto attendanceShiftApplicationDto);

  /**
   * 修改数据
   * @param attendanceShiftApplication
   * @return
   */
  AttendanceShiftApplication updateForm(AttendanceShiftApplication attendanceShiftApplication);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 根据日期生成申请周期编码 年份+周数 202201
   * @param date
   * @return
   */
  String findApplyPeriodByDate(Date date);

  /**
   * 根据用户账号和申请周期查询，applyPeriodDate可选周期内的任意一天
   * @param userAccount
   * @param applyPeriodDate
   * @return
   */
  AttendanceShiftApplication findByUserAccountAndApplyPeriod(String userAccount,Date applyPeriodDate);

  /**
   * 批量审核排班申请
   * @param dto
   */
  void updateAuditStatusByIdBatch(AttendanceShiftApplicationApproveDto dto);

  /**
   * 根据申请编码查询
   * @param applyCode
   * @return
   */
  AttendanceShiftApplication findByApplyCode(String applyCode);
}

