package com.biz.crm.cps.business.attendance.local.service;

import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftOrganizationRelationship;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;
import java.util.List;
import java.util.Set;

/**
 * 班次与导购所属组织关联关系(ShiftOrganizationRelationship)表服务接口
 *
 * @author dy
 * @since 2022-02-16 15:37:44
 */
public interface AttendanceShiftOrganizationRelationshipService {

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param attendanceShiftOrganizationRelationship 实体对象
   * @return
   */
  Page<AttendanceShiftOrganizationRelationship> findByConditions(Pageable pageable, AttendanceShiftOrganizationRelationship attendanceShiftOrganizationRelationship);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  AttendanceShiftOrganizationRelationship findById(String id);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 批量保存
   * @param shiftOrganizationRelationshipSet
   * @param shiftCode
   */
  void createBatch(String shiftCode, Set<AttendanceShiftOrganizationRelationship> shiftOrganizationRelationshipSet);

  /**
   * 根据班次编码删除
   * @param shiftCode
   */
  void deleteByShiftCode(String shiftCode);

  /**
   * 根据班次编码查询
   * @param shiftCode
   * @return
   */
  List<AttendanceShiftOrganizationRelationship> findByShiftCode(String shiftCode);

}

