package com.biz.crm.cps.business.attendance.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftPlan;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftPlanDto;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

/**
 * 排班申请计划详情(ShiftPlan)表服务接口
 *
 * @author dy
 * @since 2022-02-16 15:35:27
 */
public interface AttendanceShiftPlanService {

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param attendanceShiftPlan 实体对象
   * @return
   */
  Page<AttendanceShiftPlan> findByConditions(Pageable pageable, AttendanceShiftPlan attendanceShiftPlan);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  AttendanceShiftPlan findById(String id);
  
   /**
   * 新增数据
   * @param attendanceShiftPlan 实体对象
   * @return 新增结果
   */
  AttendanceShiftPlan create(AttendanceShiftPlan attendanceShiftPlan);
  
   /**
   * 修改新据
   * @param attendanceShiftPlan 实体对象
   * @return 修改结果
   */
  AttendanceShiftPlan update(AttendanceShiftPlan attendanceShiftPlan);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 批量保存排班计划详情
   * @param attendanceShiftPlans
   */
  void createBatch(String applyCode, List<AttendanceShiftPlanDto> attendanceShiftPlans);

  /**
   * 根据申请编码删除
   * @param applyCode
   */
  void deleteByApplyCode(String applyCode);

  /**
   * 根据导购用户账号和查询当日排班计划
   * @param date
   * @return
   */
  AttendanceShiftPlan findByCurrentUserAndDate(Date date);

  /**
   * 根据申请编码和排班日期查询排班详情
   * @param applyCode
   * @param schedulingDate
   * @return
   */
  AttendanceShiftPlan findByApplyCodeAndSchedulingDate(String applyCode,Date schedulingDate);

  /**
   * 按照用户账号和排班日期查询
   * @param userAccount
   * @param schedulingDate
   * @return
   */
  AttendanceShiftPlan findByUserAccountAndSchedulingDate(String userAccount,Date schedulingDate);

  /**
   * 根据排班日期的审核状态查询
   * @param schedulingDate
   * @param auditStatus
   * @return
   */
  List<AttendanceShiftPlan> findBySchedulingDateAndAuditStatus(Date schedulingDate,String auditStatus);
}

