package com.biz.crm.cps.business.attendance.local.service;

import com.biz.crm.cps.business.attendance.local.entity.AttendanceShift;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftDto;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 上班班次管理(WorkShift)表服务接口
 *
 * @author dy
 * @since 2022-02-16 15:40:38
 */
public interface AttendanceShiftService {

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param dto 查询条件对象
   * @return
   */
  Page<AttendanceShift> findByConditions(Pageable pageable, ShiftConditionDto dto);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  AttendanceShift findById(String id);
  
   /**
   * 新增数据
   * @param attendanceShiftDto 实体对象
   * @return 新增结果
   */
  AttendanceShift create(AttendanceShiftDto attendanceShiftDto);

  /**
   * 创建班次实体
   * @param attendanceShift
   * @return
   */
  AttendanceShift createForm(AttendanceShift attendanceShift);
  
   /**
   * 修改新据
   * @param attendanceShiftDto 实体对象
   * @return 修改结果
   */
  AttendanceShift update(AttendanceShiftDto attendanceShiftDto);

  /**
   * 修改班次
   * @param attendanceShift
   * @return
   */
  AttendanceShift updateFrom(AttendanceShift attendanceShift);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 查询当前登录用户可用的班次
   * @return
   */
  List<AttendanceShift> findByCurrentUser();

  /**
   * 根据导购账号查询可用的班次
   * @return
   */
  List<AttendanceShift> findByUserAccount(String userAccount);

}

