package com.biz.crm.cps.business.attendance.local.service.internal;


import com.biz.crm.cps.business.attendance.local.entity.AttendanceClockPictureRelationship;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceClockPictureRelationshipRepository;
import com.biz.crm.cps.business.attendance.local.service.AttendanceClockPictureRelationshipService;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockPictureDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/**
 * 打卡图片(AttendanceClockPictureRelationship)表服务实现类
 *
 * @author dy
 * @since 2022-03-07 10:29:42
 */
@Service("attendanceClockPictureRelationshipService")
public class AttendanceClockPictureRelationshipServiceImpl implements AttendanceClockPictureRelationshipService {

  @Autowired
  private AttendanceClockPictureRelationshipRepository attendanceClockPictureRelationshipRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 创建验证
   *
   * @param attendanceClockPictureRelationship
   */
  private void createValidate(AttendanceClockPictureRelationship attendanceClockPictureRelationship) {
    Validate.notNull(attendanceClockPictureRelationship, "新增时，对象信息不能为空！");
    Validate.notBlank(attendanceClockPictureRelationship.getPictureAddress(),"图片地址不能为空");
    Validate.notBlank(attendanceClockPictureRelationship.getPictureName(),"图片名称不能为空");
    attendanceClockPictureRelationship.setId(null);
  }

  @Override
  @Transactional
  public void createBatch(String clockId,Set<AttendanceClockPictureDto> attendanceClockPictures) {
    if(CollectionUtils.isEmpty(attendanceClockPictures)){
      return;
    }
    Validate.notBlank(clockId,"关联的打卡记录Id不能为空");
    Set<AttendanceClockPictureRelationship> pictures = (Set<AttendanceClockPictureRelationship>)nebulaToolkitService.copyCollectionByBlankList(attendanceClockPictures, AttendanceClockPictureDto.class, AttendanceClockPictureRelationship.class, HashSet.class, ArrayList.class);
    pictures.stream().forEach(p->{
      p.setAttendanceClockId(clockId);
      this.createValidate(p);
    });
    this.attendanceClockPictureRelationshipRepository.deleteByAttendanceClockId(clockId);
    this.attendanceClockPictureRelationshipRepository.saveOrUpdateBatch(pictures);
  }
}

